require 'pure/world/clouds/2d/clouds_main'
--dofile (__pure__path.."\\pure\\world\\clouds\\2d\\clouds_main.lua")
require 'pure/world/clouds/3d/clouds_main'
--require 'pure/world/clouds/3d_raymarching/clouds_main'

function clouds__get_cloud_coverage()
    return PURE__2DCLOUDS_get_cloud_coverage()
end

function clouds__get_sun_cover()
    return __PURE__Clouds_shadow__SkyCover
end


local _l_3d_layers = {
    shadows = {
        count = 0.0,
    }
}

local fadePosition = 0.75
function __PURE__update_clouds(dt)

    if __CSP_version > 3629 then
        ac.setCloudShadowBlur(__PURE__get_config("clouds_render.shadows_blur"))
    end

    local state = ConditionConverterGetState()
    if state~=nil then

        -- if badness is falling, make fade (skydome texture fade) much earlier.
        
        local curr_badness = WEATHER__get_weather_defintion(state.currentType, 'badness')
        local next_badness = WEATHER__get_weather_defintion(state.upcomingType, 'badness')

        if curr_badness~=nil and next_badness~=nil and next_badness < curr_badness then
            fadePosition = 0.25
        else
            fadePosition = 0.75
        end

        if __PURE__Clouds__method==1 and clouds__2D__setClouds~=nil then

            clouds__2D__setClouds(  state.currentType,
                                    state.upcomingType,
                                    state.transition,
                                    fadePosition
                                )

            clouds_2d_update(dt)

        elseif __PURE__Clouds__method==2 then
            
            __PURE___renderRaymarchingClouds__setCondition(state.currentType,
                                    state.upcomingType,
                                    state.transition,
                                    fadePosition)

            clouds_3d_raymarching_update(dt)
        end
    end
end

function __PURE__async_update_clouds(dt)

    _l_3d_layers.shadows.count = math.floor(math.max(1, __PURE__cloud_types.shadows.count * PURE__2DCLOUDS_get_cloud_coverage()))
    if CurrentConditions.overcast >= 0.8 then
        _l_3d_layers.shadows.count = 0
    end

    clouds__3D__setClouds(_l_3d_layers)

    clouds_3d_async_update(dt)

    --clouds_2d_async_update(dt)
end